from typing import List

def saisie_num(message: str) -> List[float]:
  """
  Demande à l'utilisateur de saisir des nombres
  @param message indique ce qu'il faut saisir (vitesses, notes, températures…)
  @return les nombres saisis
  """
  nombres = []
  saisie = input(message)
  while "" != saisie:
    saisie = saisie.replace(",", ".") #fr -> us
    if saisie.replace(".", "", 1).isdigit():
      valeur = float(saisie) if "." in saisie else int(saisie)
      nombres.append(valeur)
    saisie = input(message)
  return nombres

def calc_moyenne(nombres: List[float]) -> float:
  """
  Calcule la moyenne de valeurs numériques
  @param nombres les valeurs numériques
  @return la moyenne des nombres
  pré-condition: nombres n'est pas vide (il y en a au moins un)
  """
  assert len(nombres) != 0, 'il faut au moins un nombre !'
  somme = 0
  for i in range(len(nombres)):
    somme += nombres[i]
  return somme / len(nombres)

if __name__ == "__main__": #prog principal / point d'entrée
  notes = saisie_num("Note : ")
  moyenne = calc_moyenne(notes)
  print(notes)
  print(str(moyenne))





